#!/bin/bash

# Create a log directory
LOGDIR="$HOME/sar_logs_$(date +%Y%m%d_%H%M%S)"
mkdir -p "$LOGDIR"

echo "Logging sar output to: $LOGDIR"

# Run each sar command in the background
sar -u 1 > "$LOGDIR/cpu_usage.log" &
sar -P ALL 1 > "$LOGDIR/per_cpu.log" &
sar -q 1 > "$LOGDIR/load_avg.log" &
sar -W 1 > "$LOGDIR/paging.log" &

sar -r 1 > "$LOGDIR/mem_usage.log" &
sar -R 1 > "$LOGDIR/mem_paging.log" &
sar -B 1 > "$LOGDIR/page_faults.log" &
sar -S 1 > "$LOGDIR/swap_usage.log" &

sar -b 1 > "$LOGDIR/block_io.log" &
sar -d 1 > "$LOGDIR/disk_io.log" &
sar -p 1 > "$LOGDIR/partition_io.log" &
sar -u -x ALL 1 > "$LOGDIR/cpu_per_process.log" &

sar -n DEV 1 > "$LOGDIR/net_dev.log" &
sar -n EDEV 1 > "$LOGDIR/net_errors.log" &
sar -n SOCK 1 > "$LOGDIR/sock_usage.log" &
sar -n IP 1 > "$LOGDIR/ip_stats.log" &
sar -n TCP,UDP 1 > "$LOGDIR/tcp_udp.log" &

sar -v 1 > "$LOGDIR/process_creation.log" &
sar -w 1 > "$LOGDIR/context_switches.log" &
sar -y 1 > "$LOGDIR/tty_activity.log" &

# Save PIDs of all background sar processes
jobs -p > "$LOGDIR/sar_pids.txt"
echo "All sar processes started. To stop them, run:"
echo "  xargs kill < "$LOGDIR/sar_pids.txt""
