#!/bin/bash

# Find the latest sar_logs directory
LATEST_LOGDIR=$(ls -td $HOME/sar_logs_* | head -1)

if [ -z "$LATEST_LOGDIR" ]; then
  echo "No sar_logs directory found."
  exit 1
fi

PID_FILE="$LATEST_LOGDIR/sar_pids.txt"

if [ ! -f "$PID_FILE" ]; then
  echo "No PID file found at $PID_FILE"
  exit 1
fi

echo "Stopping sar processes listed in $PID_FILE..."
xargs kill < "$PID_FILE"
echo "Stopped."

# Compress the log directory into a tar.gz file
ARCHIVE_NAME="${LATEST_LOGDIR}.tar.gz"
echo "Compressing logs to $ARCHIVE_NAME..."
tar -czf "$ARCHIVE_NAME" -C "$(dirname "$LATEST_LOGDIR")" "$(basename "$LATEST_LOGDIR")"
echo "Compression complete."
